# 画面設計書 160-Cat セグメント

## 概要

本ドキュメントは、OpenSearchのCat Segments API（`GET /_cat/segments`）エンドポイントに関する画面設計書である。各インデックスのLuceneセグメント情報をテーブル形式で返すAPIの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：インデックスを構成するLuceneセグメントの詳細情報を一覧形式で確認するために使用される。セグメント数、サイズ、ドキュメント数、コミット状態、検索可能状態、コンパウンド形式かどうかなどを監視し、マージの最適化やインデックスのパフォーマンスチューニングに活用される。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/segments` または `GET /_cat/segments/{index}` にリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. ClusterStateRequestでノード情報とルーティングテーブルを取得する
2. レスポンス制限チェックを実行する
3. IndicesSegmentsRequestでセグメント情報を取得する
4. インデックス・シャード・セグメントの階層でテーブルを構築する

**画面遷移**：本APIはステートレスなREST APIである。インデックスセグメントAPI（`GET /{index}/_segments`）と関連する。

**権限による表示制御**：セキュリティプラグインが有効な場合、インデックスモニタリング権限が必要となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 106 | セグメント管理 | 主機能 | Luceneセグメント情報をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式のセグメント情報表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/segments` | 全インデックスのセグメント情報をテーブル形式で返す |
| GET | `/_cat/segments/{index}` | 指定インデックスのセグメント情報をテーブル形式で返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| index | list | No | - | インデックス名のカンマ区切りリスト（パスパラメータ） |
| format | string | No | - | レスポンス形式（json, yamlなど） |
| bytes | enum | No | - | バイト値の表示単位 |
| local | boolean | No | false | ローカル情報を返す |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | **非推奨**: cluster_manager_timeoutを使用 |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| v | boolean | No | false | 冗長モード。カラムヘッダーを表示 |

## 表示項目

| カラム名 | エイリアス | デフォルト表示 | 説明 |
|---------|-----------|-------------|------|
| index | i,idx | Yes | インデックス名 |
| shard | s,sh | Yes | シャード番号 |
| prirep | p,pr,primaryOrReplica | Yes | プライマリ(p)またはレプリカ(r) |
| ip | - | Yes | シャードが存在するノードのIPアドレス |
| id | - | No | シャードが存在するノードID |
| segment | seg | Yes | セグメント名 |
| generation | g,gen | Yes | セグメント世代番号 |
| docs.count | dc,docsCount | Yes | セグメント内ドキュメント数 |
| docs.deleted | dd,docsDeleted | Yes | セグメント内削除済みドキュメント数 |
| size | si | Yes | セグメントサイズ（バイト） |
| size.memory | sm,sizeMemory | Yes | セグメントメモリ使用量（バイト） |
| committed | ic,isCommitted | Yes | セグメントがコミット済みか |
| searchable | is,isSearchable | Yes | セグメントが検索可能か |
| version | v,ver | Yes | Luceneバージョン |
| compound | ico,isCompound | Yes | コンパウンドファイル形式か |

## イベント仕様

### 1-GETリクエスト受信

クライアントからのGETリクエストを受信すると、`RestSegmentsAction.doCatRequest()` が呼び出される。まずClusterStateRequestでノード情報とルーティングテーブルを取得し、レスポンス制限チェックを実行する。制限を超過していない場合、IndicesSegmentsRequestでセグメント情報を取得し、インデックス -> シャード -> セグメントの3階層でテーブルを構築する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | 参照のみ。データベースへの更新は発生しない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|-------------|
| 正常応答 | セグメント情報取得成功時 | テーブル形式のセグメント情報 |
| エラー | レスポンス制限超過時 | "Segments from too many indices requested." |

## 例外処理

- ResponseLimitBreachedException: インデックス数がレスポンス制限を超過した場合に発生（行129-136のvalidateRequestLimit）
- インデックスが存在しない場合：IndexNotFoundExceptionが返される
- ノード情報が解決できない場合：NullPointerExceptionの可能性あり

## 備考

- ResponseLimitSettingsによるインデックス数制限が適用される（isRequestLimitCheckSupportedがtrue）
- size.memoryは常に0Lが返される（行194）- Luceneのメモリマッピング変更による
- allowSystemIndexAccessByDefaultがtrueで、システムインデックスへのアクセスが許可される
- セグメントの3階層イテレーション：IndexSegments -> IndexShardSegments -> ShardSegments -> Segment

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Segment.java | `server/src/main/java/org/opensearch/index/engine/Segment.java` | getName(), getGeneration(), getNumDocs(), getDeletedDocs(), getSize(), isCommitted(), isSearch(), isCompound(), getVersion()を保持 |
| 1-2 | IndexSegments.java | `server/src/main/java/org/opensearch/action/admin/indices/segments/IndexSegments.java` | getShards()でMap<Integer, IndexShardSegments>を返す |
| 1-3 | ShardSegments.java | `server/src/main/java/org/opensearch/action/admin/indices/segments/ShardSegments.java` | getSegments()でList<Segment>を返す |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestSegmentsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestSegmentsAction.java` | Cat Segments APIのエントリーポイント |

**主要処理フロー**:
1. **行80-81**: `routes()` で2つのルート登録
2. **行100-127**: `doCatRequest()` でClusterState -> IndicesSegmentsの2段階リクエスト
3. **行114**: `validateRequestLimit()` でレスポンス制限チェック
4. **行145-165**: `getTableWithHeader()` で15カラムのテーブルヘッダー定義
5. **行167-209**: `buildTable()` で3階層イテレーションによるテーブル構築

#### Step 3: レスポンス制限を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResponseLimitSettings.java | `server/src/main/java/org/opensearch/common/breaker/ResponseLimitSettings.java` | getCatSegmentsResponseLimit()でセグメントAPI用の制限値を取得 |

### プログラム呼び出し階層図

```
RestSegmentsAction.doCatRequest() [行100]
    |
    +-- ClusterStateRequest (nodes=true, routingTable=true) [行103-109]
    |
    +-- client.admin().cluster().state() [行111]
           |
           +-- validateRequestLimit() [行114, 行129-136]
           |
           +-- IndicesSegmentsRequest(indices) [行115-116]
           |
           +-- client.admin().indices().segments() [行117]
                  |
                  +-- buildTable() [行167]
                         +-- getTableWithHeader() [行145]
                         +-- IndexSegments -> IndexShardSegments -> ShardSegments -> Segment [行172-206]
```

### データフロー図

```
[入力]                    [処理]                           [出力]

GET /_cat/segments    --> RestSegmentsAction              --> テーブル形式
GET /_cat/segments/{i}    |
                          v
                     ClusterState (nodes, routingTable)
                          |
                          v
                     validateRequestLimit()
                          |
                          v
                     IndicesSegmentsRequest
                          |
                          v
                     IndicesSegmentResponse
                          |
                          v
                     IndexSegments
                          |
                          v
                     IndexShardSegments
                          |
                          v
                     ShardSegments -> Segment[]
                          |
                          v
                     buildTable() --> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestSegmentsAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestSegmentsAction.java` | ソース | Cat Segments APIのRESTハンドラ |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| Segment.java | `server/src/main/java/org/opensearch/index/engine/Segment.java` | ソース | Luceneセグメントデータ構造 |
| IndexSegments.java | `server/src/main/java/org/opensearch/action/admin/indices/segments/IndexSegments.java` | ソース | インデックスセグメント集約 |
| ShardSegments.java | `server/src/main/java/org/opensearch/action/admin/indices/segments/ShardSegments.java` | ソース | シャードセグメント集約 |
| ResponseLimitSettings.java | `server/src/main/java/org/opensearch/common/breaker/ResponseLimitSettings.java` | ソース | レスポンス制限設定 |
| cat.segments.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.segments.json` | 設定 | REST API仕様定義 |
